/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class PlumTreeFeature
extends BlueprintTreeFeature {
    public PlumTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context) {
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        int trunkHeight = config.f_68190_.m_226153_(random);
        for (int y = 0; y < trunkHeight; ++y) {
            this.addLog(origin.m_6630_(y));
        }
        Direction.Plane.HORIZONTAL.m_122557_().forEach(direction -> {
            BlockPos stumpPos = origin.m_121945_(direction);
            if (random.m_188503_(3) != 0 && PlumTreeFeature.m_65788_((LevelSimulatedReader)context.m_159774_(), (BlockPos)stumpPos.m_7495_())) {
                this.addLog(stumpPos);
                if (random.m_188503_(3) == 0) {
                    this.addLog(stumpPos.m_7494_());
                }
            }
        });
        Direction.Plane.HORIZONTAL.m_122557_().forEach(direction -> {
            BlockPos newPos = this.createPlumBranch(origin.m_6630_(trunkHeight - random.m_188503_(3)), (Direction)direction, random);
            for (int i = 0; i < 5; ++i) {
                this.createPlumLeaves(newPos.m_7494_().m_6625_(i), random, i);
            }
        });
    }

    private void createPlumLeaves(BlockPos pos, RandomSource random, int leafLevel) {
        int leafSize = 2;
        for (int k = -leafSize; k <= leafSize; ++k) {
            for (int j = -leafSize; j <= leafSize; ++j) {
                if (leafLevel == 2) {
                    this.addFoliage(pos.m_7918_(k, 0, j));
                    continue;
                }
                if (leafLevel > 1 && leafLevel < 4 && (Math.abs(k) != leafSize || Math.abs(j) != leafSize)) {
                    this.addFoliage(pos.m_7918_(k, 0, j));
                    continue;
                }
                if ((leafLevel == 1 || leafLevel == 4) && Math.abs(k) <= 1 && Math.abs(j) <= 1) {
                    if ((Math.abs(k) == 1 && Math.abs(j) == 1 && leafLevel == 4 || Math.abs(k) == 2 && Math.abs(j) == 2) && !random.m_188499_()) continue;
                    this.addFoliage(pos.m_7918_(k, 0, j));
                    continue;
                }
                if (leafLevel != 1) continue;
                if (random.m_188503_(3) == 0 && (Math.abs(k) == 1 && Math.abs(j) == 2 || Math.abs(k) == 2 && Math.abs(j) == 1)) {
                    this.addFoliage(pos.m_7918_(k, 0, j));
                    continue;
                }
                if (random.m_188503_(4) == 0 || (Math.abs(k) != 0 || Math.abs(j) != 2) && (Math.abs(k) != 2 || Math.abs(j) != 0)) continue;
                this.addFoliage(pos.m_7918_(k, 0, j));
            }
        }
    }

    private BlockPos createPlumBranch(BlockPos pos, Direction direction, RandomSource random) {
        int i;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        int length = 2 + random.m_188503_(2);
        for (i = 0; i < length; ++i) {
            this.addLog(mutablePos.m_121945_(direction));
            if (random.m_188503_(3) != 0) {
                mutablePos.m_122190_((Vec3i)mutablePos.m_7494_());
            }
            mutablePos.m_122190_((Vec3i)mutablePos.m_5484_(direction, random.m_188503_(2)));
        }
        for (i = 0; i < 3; ++i) {
            this.addLog(mutablePos.m_121945_(direction));
            mutablePos.m_122190_((Vec3i)mutablePos.m_7494_());
        }
        return mutablePos.m_121945_(direction);
    }

    public BlockState getSapling() {
        return ((Block)EnvironmentalBlocks.PLUM_SAPLING.get()).m_49966_();
    }
}

