/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class FallenPineTreeFeature
extends Feature<NoneFeatureConfiguration> {
    private static final List<Direction> XY_PLANE = List.of(Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST);
    private static final List<Direction> YZ_PLANE = List.of(Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH);
    private HashMap<BlockPos, Direction.Axis> logPositions;
    private Set<BlockPos> leafPositions;

    public FallenPineTreeFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
        int length = this.getLength(random);
        int xOffset = direction.m_122434_() == Direction.Axis.X ? length / 2 : 0;
        int zOffset = direction.m_122434_() == Direction.Axis.Z ? length / 2 : 0;
        block0: for (int i = 0; i < 8; ++i) {
            BlockPos pos = origin.m_7918_(random.m_188503_(4) - random.m_188503_(4) - xOffset, random.m_188503_(2) - random.m_188503_(2), random.m_188503_(4) - random.m_188503_(4) - zOffset);
            if (!FallenPineTreeFeature.canGenerateAt(level, pos, direction, length)) continue;
            this.logPositions = Maps.newHashMap();
            this.leafPositions = Sets.newHashSet();
            this.doPlace(level, random, pos, length, direction);
            ChunkPos chunkPos = level.m_46865_(origin).m_7697_();
            for (BlockPos leafPos : this.leafPositions) {
                if (this.checkChunkDistance(level, chunkPos, leafPos)) continue;
                continue block0;
            }
            for (BlockPos logPos : this.logPositions.keySet()) {
                if (this.checkChunkDistance(level, chunkPos, logPos)) continue;
                continue block0;
            }
            for (BlockPos leafPos : this.leafPositions) {
                level.m_7731_(leafPos, ((Block)EnvironmentalBlocks.PINE_LEAVES.get()).m_49966_(), 19);
            }
            for (BlockPos logPos : this.logPositions.keySet()) {
                level.m_7731_(logPos, (BlockState)((Block)EnvironmentalBlocks.PINE_LOG.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)this.logPositions.get(logPos)), 19);
                if (!level.m_8055_(logPos.m_7495_()).m_60713_(Blocks.f_50440_)) continue;
                level.m_7731_(logPos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
            }
            BoundingBox.m_162378_((Iterable)Iterables.concat(this.logPositions.keySet(), this.leafPositions)).ifPresent(boundingBox -> {
                DiscreteVoxelShape shape = TreeFeature.m_225251_((LevelAccessor)level, (BoundingBox)boundingBox, this.logPositions.keySet(), Set.of(), Set.of());
                StructureTemplate.m_74510_((LevelAccessor)level, (int)3, (DiscreteVoxelShape)shape, (int)boundingBox.m_162395_(), (int)boundingBox.m_162396_(), (int)boundingBox.m_162398_());
            });
            return true;
        }
        return false;
    }

    private boolean checkChunkDistance(WorldGenLevel level, ChunkPos chunkPos, BlockPos pos) {
        return Math.abs(chunkPos.f_45578_ - level.m_46865_((BlockPos)pos).m_7697_().f_45578_) <= 1 && Math.abs(chunkPos.f_45579_ - level.m_46865_((BlockPos)pos).m_7697_().f_45579_) <= 1;
    }

    private void doPlace(WorldGenLevel level, RandomSource random, BlockPos origin, int length, Direction direction) {
        int l;
        float f;
        List<Direction> plane = direction.m_122434_() == Direction.Axis.X ? YZ_PLANE : XY_PLANE;
        for (int j = 0; j < length; ++j) {
            this.logPositions.put(origin.m_5484_(direction, j), direction.m_122434_());
        }
        boolean topleaves = random.m_188499_();
        if (topleaves) {
            this.createTopLeaves(level, origin.m_5484_(direction, length), direction);
        }
        if (random.m_188503_(3) == 0) {
            this.createRootDirt(level, random, origin.m_121945_(direction.m_122424_()), direction);
        }
        int topbranches = (f = random.m_188501_()) > 0.6f ? 3 : (f > 0.25f ? 2 : (f > 0.05f ? 1 : 0));
        ArrayList branchdirections = Lists.newArrayList();
        plane.forEach(branchdirections::add);
        int n = l = topleaves ? length - 4 : length - 2;
        while (l > 0) {
            BlockPos blockpos = origin.m_5484_(direction, l);
            if (topbranches > 0 || random.m_188503_(l > 4 ? 2 : 4) == 0) {
                Direction branchdirection = topbranches > 0 ? (Direction)branchdirections.remove(random.m_188503_(branchdirections.size())) : plane.get(random.m_188503_(4));
                BlockPos branchpos = blockpos.m_121945_(branchdirection);
                if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)branchpos)) {
                    this.logPositions.put(branchpos, branchdirection.m_122434_());
                }
                if (topbranches > 0) {
                    --topbranches;
                }
            }
            if (topbranches == 0) {
                l -= 2 + random.m_188503_(2);
                continue;
            }
            if (topbranches == 1 && random.m_188503_(3) == 0) {
                l -= 2;
                continue;
            }
            --l;
        }
    }

    private void createTopLeaves(WorldGenLevel level, BlockPos pos, Direction direction) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int y = 0; y <= 3; ++y) {
            int r = y < 3 ? y : 1;
            block1: for (int x = -r; x <= r; ++x) {
                for (int z = r; z >= -r; --z) {
                    if (z >= 2 || Math.abs(x) + Math.abs(z) > r) continue;
                    mutable.m_175306_((Vec3i)pos, FallenPineTreeFeature.rotateToDirection(x, 1 - y, z, direction));
                    if (!TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)mutable)) continue block1;
                    this.leafPositions.add(mutable.m_7949_());
                }
            }
        }
    }

    private void createRootDirt(WorldGenLevel level, RandomSource random, BlockPos pos, Direction direction) {
        if (!TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos)) {
            return;
        }
        Direction.Axis axis = direction.m_122434_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        block0: for (int h = 1; h >= -1; --h) {
            for (int y = 1; y >= -1; --y) {
                if (h != 0 && y != 0 && random.m_188503_(3) != 0) continue;
                if (axis == Direction.Axis.X) {
                    mutable.m_122154_((Vec3i)pos, 0, y, h);
                    continue block0;
                }
                mutable.m_122154_((Vec3i)pos, h, y, 0);
                continue block0;
            }
        }
    }

    private static Vec3i rotateToDirection(int x, int y, int z, Direction direction) {
        return new Vec3i(direction.m_122431_() * x + direction.m_122429_() * y, z, direction.m_122429_() * x + direction.m_122431_() * y);
    }

    private static boolean canGenerateAt(WorldGenLevel level, BlockPos pos, Direction direction, int length) {
        if (!FallenPineTreeFeature.m_159759_((BlockState)level.m_8055_(pos.m_121945_(direction.m_122424_()).m_7495_()))) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        int supportblocks = 0;
        for (int i = 0; i < length; ++i) {
            if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)mutable)) {
                BlockPos belowpos = mutable.m_7495_();
                BlockState belowstate = level.m_8055_(belowpos);
                if (belowstate.m_60783_((BlockGetter)level, belowpos, Direction.UP)) {
                    ++supportblocks;
                }
            } else {
                return false;
            }
            mutable.m_122173_(direction);
        }
        return (float)supportblocks >= (float)length * 0.7f;
    }

    protected int getLength(RandomSource random) {
        return 9 + random.m_188503_(5);
    }
}

