/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.zebroid;

import com.teamabnormals.environmental.common.entity.ai.goal.HerdLandWanderGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebraFleeGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidFollowParentGoal;
import com.teamabnormals.environmental.common.entity.animal.zebroid.AbstractUnchestedZebroid;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zonkey;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zorse;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.level.Level;

public class Zebra
extends AbstractUnchestedZebroid {
    private static final float MIN_DAMAGE = Zebra.generateAttackDamage(value -> 0);
    private static final float MAX_DAMAGE = Zebra.generateAttackDamage(value -> value - 1);
    private ZebraFleeGoal fleeGoal;

    public Zebra(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_7509_() {
        this.fleeGoal = new ZebraFleeGoal(this, 1.8);
        this.f_21345_.m_25352_(2, (Goal)this.fleeGoal);
        this.f_21345_.m_25352_(6, new ZebroidFollowParentGoal<Zebra>(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new HerdLandWanderGoal((PathfinderMob)this, 0.7, 1.2, 16));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractHorse.m_30627_().m_22266_(Attributes.f_22281_).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 8.0);
    }

    protected void m_214179_(RandomSource random) {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)Zebra.m_271722_(arg_0 -> ((RandomSource)random).m_188503_(arg_0)));
        this.m_21051_(Attributes.f_22279_).m_22100_(Zebra.m_271981_(() -> ((RandomSource)random).m_188500_()));
        this.m_21051_(Attributes.f_22288_).m_22100_(Zebra.m_272017_(() -> ((RandomSource)random).m_188500_()));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)Zebra.generateAttackDamage(arg_0 -> ((RandomSource)random).m_188503_(arg_0)));
    }

    private static float generateAttackDamage(IntUnaryOperator random) {
        return 1.0f + (float)random.applyAsInt(2) + (float)random.applyAsInt(2) + (float)random.applyAsInt(2);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_AMBIENT.get();
    }

    protected SoundEvent m_7871_() {
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_ANGRY.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_DEATH.get();
    }

    protected SoundEvent m_7872_() {
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_EAT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        if (!this.isKicking()) {
            super.m_7975_(source);
        }
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_HURT.get();
    }

    public void m_6703_(@Nullable LivingEntity attacker) {
        if (attacker != null && this.m_9236_() instanceof ServerLevel) {
            int fleetime = this.m_217043_().m_188503_(40) + 100;
            float fleedirection = this.m_217043_().m_188501_() * 360.0f;
            List<Zebra> zebras = this.m_9236_().m_6443_(Zebra.class, this.m_20191_().m_82377_(10.0, 4.0, 10.0), zebra -> zebra != this && !zebra.isFleeing() && !zebra.m_30614_() && zebra.m_5448_() == null).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)this))).limit(3L).toList();
            for (Zebra zebra2 : zebras) {
                zebra2.getFleeGoal().trigger(fleetime, fleedirection);
            }
            if (this.m_6162_()) {
                this.fleeGoal.trigger(fleetime, fleedirection);
            }
        }
        super.m_6703_(attacker);
    }

    public ZebraFleeGoal getFleeGoal() {
        return this.fleeGoal;
    }

    @Override
    public boolean isFleeing() {
        return this.fleeGoal.running();
    }

    public boolean m_7848_(Animal otherParent) {
        if (otherParent == this) {
            return false;
        }
        if (!(otherParent instanceof Zebra || otherParent instanceof Horse || otherParent instanceof Donkey)) {
            return false;
        }
        return this.m_30628_() && ((AbstractHorse)otherParent).m_30628_();
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        if (otherParent instanceof Horse) {
            Horse horse = (Horse)otherParent;
            Zorse zorse = (Zorse)((EntityType)EnvironmentalEntityTypes.ZORSE.get()).m_20615_((Level)level);
            if (zorse != null) {
                int i = this.f_19796_.m_188503_(9);
                Variant variant = i < 8 ? horse.m_28554_() : (Variant)Util.m_214670_((Object[])Variant.values(), (RandomSource)this.f_19796_);
                int j = this.f_19796_.m_188503_(5);
                Markings markings = j < 2 ? Markings.NONE : (j < 4 ? horse.m_30724_() : (Markings)Util.m_214670_((Object[])Markings.values(), (RandomSource)this.f_19796_));
                zorse.randomizeStripeOpacity(level.m_213780_());
                zorse.setVariantAndMarkings(variant, markings);
                this.m_149508_(otherParent, zorse);
            }
            return zorse;
        }
        if (otherParent instanceof Donkey) {
            Zonkey zonkey = (Zonkey)((EntityType)EnvironmentalEntityTypes.ZONKEY.get()).m_20615_((Level)level);
            if (zonkey != null) {
                zonkey.randomizeStripeOpacity(level.m_213780_());
                this.m_149508_(otherParent, (AbstractHorse)zonkey);
            }
            return zonkey;
        }
        Zebra zebra = (Zebra)((EntityType)EnvironmentalEntityTypes.ZEBRA.get()).m_20615_((Level)level);
        if (zebra != null) {
            this.m_149508_(otherParent, zebra);
        }
        return zebra;
    }

    public void m_149508_(AgeableMob otherParent, AbstractHorse child) {
        super.m_149508_(otherParent, child);
        double d0 = otherParent instanceof Horse ? Zebra.m_271715_((double)this.m_21172_(Attributes.f_22281_), (double)0.0, (double)Zorse.MIN_DAMAGE, (double)Zorse.MAX_DAMAGE, (RandomSource)this.f_19796_) : (otherParent instanceof Donkey ? Zebra.m_271715_((double)this.m_21172_(Attributes.f_22281_), (double)0.0, (double)Zonkey.MIN_DAMAGE, (double)Zonkey.MAX_DAMAGE, (RandomSource)this.f_19796_) : Zebra.m_271715_((double)this.m_21172_(Attributes.f_22281_), (double)0.0, (double)MIN_DAMAGE, (double)MAX_DAMAGE, (RandomSource)this.f_19796_));
        child.m_21051_(Attributes.f_22281_).m_22100_(d0);
    }

    public double m_6048_() {
        return super.m_6048_() - 0.175;
    }
}

