/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.yak;

import com.mojang.serialization.Dynamic;
import com.teamabnormals.environmental.common.entity.animal.yak.Yaktelligence;
import com.teamabnormals.environmental.common.item.YakPantsItem;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IForgeShearable;

public class Yak
extends Animal
implements IForgeShearable,
Shearable {
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(Yak.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(Yak.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int grazeTimer;
    private boolean ramming;
    private int rammingTick;

    public Yak(EntityType<? extends Yak> type, Level worldIn) {
        super(type, worldIn);
    }

    protected Brain.Provider<Yak> m_5490_() {
        return Yaktelligence.createProvider();
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return Yaktelligence.createBrain(this, (Brain<Yak>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<Yak> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnData, CompoundTag tag) {
        Yaktelligence.createMemories(this, level.m_213780_());
        return super.m_6518_(level, difficulty, spawnType, spawnData, tag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHEARED, (Object)false);
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sheared", this.isSheared());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSheared(compound.m_128471_("Sheared"));
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("yakBrain");
        Yaktelligence.tick(this);
        this.m_9236_().m_46473_().m_7238_();
        if (Yaktelligence.isFighting(this.m_6274_())) {
            this.f_20889_ = this.f_19797_;
        }
        super.m_8024_();
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            if (this.grazeTimer > 0) {
                --this.grazeTimer;
            }
            this.rammingTick = this.ramming ? ++this.rammingTick : (this.rammingTick -= 2);
            this.rammingTick = Mth.m_14045_((int)this.rammingTick, (int)0, (int)10);
        }
        super.m_8107_();
    }

    public void m_7822_(byte id) {
        switch (id) {
            case 10: {
                this.grazeTimer = 40;
                break;
            }
            case 11: {
                this.grazeTimer = 0;
                break;
            }
            case 58: {
                this.ramming = true;
                break;
            }
            case 59: {
                this.ramming = false;
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42446_) && !this.m_6162_()) {
            player.m_5496_((SoundEvent)EnvironmentalSoundEvents.YAK_MILK.get(), 1.0f, 1.0f);
            ItemStack newStack = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_42455_.m_7968_());
            player.m_21008_(hand, newStack);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_204132_(EnvironmentalItemTags.YAK_FOOD).test(stack);
    }

    public float getHeadEatingOffset(float partialTicks) {
        if (this.grazeTimer <= 0) {
            return 0.0f;
        }
        if (this.grazeTimer >= 4 && this.grazeTimer <= 36) {
            return 1.0f;
        }
        return this.grazeTimer < 4 ? ((float)this.grazeTimer - partialTicks) / 4.0f : -((float)(this.grazeTimer - 40) - partialTicks) / 4.0f;
    }

    public float getHeadPitch(float partialTicks) {
        float rammingPitch = (float)this.rammingTick / 10.0f * 30.0f * (float)Math.PI / 180.0f;
        if (rammingPitch != 0.0f) {
            return rammingPitch;
        }
        if (this.grazeTimer > 4 && this.grazeTimer <= 36) {
            return 0.62831855f + 0.22f * Mth.m_14031_((float)(((float)(this.grazeTimer - 4) - partialTicks) / 32.0f * 28.7f));
        }
        return this.grazeTimer > 0 ? 0.62831855f : Mth.m_14179_((float)partialTicks, (float)this.f_19860_, (float)this.m_146909_()) * ((float)Math.PI / 180);
    }

    public void m_8035_() {
        this.setSheared(false);
        if (this.m_6162_()) {
            this.m_146758_(60);
        }
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    public boolean isShearable(ItemStack item, Level world, BlockPos pos) {
        return this.m_6220_();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 2.5);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)EnvironmentalSoundEvents.YAK_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSoundEvents.YAK_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EnvironmentalSoundEvents.YAK_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public float m_6100_() {
        return 0.8f;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        world.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!world.f_46443_) {
            this.setSheared(true);
            if (player != null && !player.m_7500_() && !(player.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof YakPantsItem)) {
                Yaktelligence.retaliate(this, (LivingEntity)player);
            }
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            int i = 4 + this.f_19796_.m_188503_(12);
            for (int j = 0; j < i; ++j) {
                items.add(new ItemStack((ItemLike)EnvironmentalItems.YAK_HAIR.get()));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)((EntityType)EnvironmentalEntityTypes.YAK.get()).m_20615_((Level)world);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.m_6162_() ? size.f_20378_ * 0.95f : 1.3f;
    }

    public void m_5851_(SoundSource category) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, category, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 4 + this.f_19796_.m_188503_(12);
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = this.m_20000_((ItemLike)EnvironmentalItems.YAK_HAIR.get(), 1);
            if (itementity == null) continue;
            itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        Entity entity;
        boolean wasHurt = super.m_6469_(damageSource, damage);
        if (!this.m_9236_().m_5776_() && wasHurt && (entity = damageSource.m_7639_()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            Yaktelligence.wasHurtBy(this, entity2);
        }
        return wasHurt;
    }
}

