/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.slabfish;

import com.mojang.serialization.Codec;
import net.minecraft.ChatFormatting;
import net.minecraft.util.StringRepresentable;

public enum SlabfishRarity implements StringRepresentable
{
    COMMON("common", ChatFormatting.GRAY, 1.0f),
    UNCOMMON("uncommon", ChatFormatting.GREEN, 0.55f),
    RARE("rare", ChatFormatting.AQUA, 0.15f),
    EPIC("epic", ChatFormatting.LIGHT_PURPLE, 0.08f),
    LEGENDARY("legendary", ChatFormatting.GOLD, 0.02f);

    public static final Codec<SlabfishRarity> CODEC;
    private final String serializationKey;
    private final ChatFormatting color;
    private final float chance;

    private SlabfishRarity(String key, ChatFormatting color, float chance) {
        this.serializationKey = key;
        this.color = color;
        this.chance = chance;
    }

    public ChatFormatting getFormatting() {
        return this.color;
    }

    public float getChance() {
        return this.chance;
    }

    public static SlabfishRarity byChance(float chance) {
        for (int i = SlabfishRarity.values().length - 1; i > 0; --i) {
            if (!(chance <= SlabfishRarity.values()[i].getChance())) continue;
            return SlabfishRarity.values()[i];
        }
        return COMMON;
    }

    public static SlabfishRarity byId(int id) {
        if (id < 0 || id >= SlabfishRarity.values().length) {
            return COMMON;
        }
        return SlabfishRarity.values()[id];
    }

    public String getSerializationKey() {
        return this.serializationKey;
    }

    public String m_7912_() {
        return this.getSerializationKey();
    }

    static {
        CODEC = StringRepresentable.m_216439_(SlabfishRarity::values);
    }
}

