/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.tapir;

import com.teamabnormals.environmental.common.entity.animal.Tapir;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TapirHuntFloraGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    private final Tapir tapir;
    private Tapir partner;
    private int grazeTime;
    private int romanticDinnerTime;
    private int delayCounter;

    public TapirHuntFloraGoal(Tapir tapir) {
        this.tapir = tapir;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.tapir.getTrackingTime() > 0 && this.tapir.hasFloraPos();
    }

    public void m_8056_() {
        this.moveTo(this.tapir.getFloraPos());
        this.grazeTime = this.m_183277_(200 + this.tapir.m_217043_().m_188503_(100));
        this.partner = null;
        this.delayCounter = 0;
    }

    public void m_8041_() {
        this.tapir.setRunning(false);
        this.tapir.setGrazing(false);
        this.tapir.stopTracking();
    }

    public void m_8037_() {
        BlockPos florapos = this.tapir.getFloraPos();
        BlockState florastate = this.tapir.m_9236_().m_8055_(florapos);
        if (!florastate.m_60734_().m_7397_((BlockGetter)this.tapir.m_9236_(), florapos, florastate).m_150930_(this.tapir.getFloraItem())) {
            if (this.tapir.isGrazing()) {
                this.tapir.stopTracking();
                return;
            }
            if (florapos.m_123314_((Vec3i)this.tapir.m_20183_(), 5.0)) {
                this.tapir.m_9236_().m_7605_((Entity)this.tapir, (byte)5);
                this.tapir.m_216990_((SoundEvent)EnvironmentalSoundEvents.TAPIR_REJECT.get());
                this.tapir.stopTracking();
                return;
            }
        }
        if (florapos.m_123314_((Vec3i)this.tapir.m_20183_(), 1.5)) {
            this.tapir.m_21563_().m_24950_((double)florapos.m_123341_() + 0.5, this.tapir.m_20188_(), (double)florapos.m_123343_() + 0.5, 10.0f, (float)this.tapir.m_8132_());
            if (!this.tapir.isGrazing()) {
                this.tapir.setRunning(false);
                this.tapir.setGrazing(true);
                this.tapir.m_21573_().m_26573_();
            } else {
                if (--this.grazeTime <= 0) {
                    this.tapir.m_9236_().m_46961_(florapos, false);
                    this.tapir.stopTracking();
                    Vec3 vec3 = DefaultRandomPos.m_148403_((PathfinderMob)this.tapir, (int)10, (int)7);
                    if (vec3 != null) {
                        this.moveTo(BlockPos.m_274446_((Position)vec3));
                    }
                }
                if (this.tapir.m_146764_() == 0) {
                    if (this.partner == null) {
                        Tapir partner = this.findClosestPartner();
                        if (partner != null) {
                            this.partner = partner;
                            this.romanticDinnerTime = this.m_183277_(80);
                            if (this.grazeTime < this.m_183277_(200)) {
                                this.grazeTime = this.m_183277_(200);
                            }
                            if (!this.tapir.getFloraPos().equals((Object)partner.getFloraPos())) {
                                this.tapir.setFloraPos(partner.getFloraPos());
                            }
                        }
                    } else if (this.canBreedWith(this.partner) && this.tapir.getFloraPos().equals((Object)this.partner.getFloraPos())) {
                        if (--this.romanticDinnerTime <= 0) {
                            this.tapir.m_27563_((ServerLevel)this.tapir.m_9236_(), this.partner);
                        }
                    } else {
                        this.partner = null;
                    }
                }
            }
        } else {
            if (--this.delayCounter <= 0) {
                this.delayCounter = this.m_183277_(5);
                this.moveTo(florapos);
                this.tapir.setRunning(true);
            }
            this.tapir.m_21563_().m_24950_((double)florapos.m_123341_() + 0.5, (double)florapos.m_123342_() + 0.5, (double)florapos.m_123343_() + 0.5, 10.0f, (float)this.tapir.m_8132_());
            this.tapir.setGrazing(false);
        }
    }

    @Nullable
    private Tapir findClosestPartner() {
        List list = this.tapir.m_9236_().m_45971_(Tapir.class, PARTNER_TARGETING, (LivingEntity)this.tapir, this.tapir.m_20191_().m_82400_(8.0));
        double d0 = Double.MAX_VALUE;
        Tapir partner = null;
        for (Tapir entity : list) {
            double d1 = this.tapir.m_20280_((Entity)entity);
            if (!this.canBreedWith(entity) || !(d1 < d0)) continue;
            d0 = d1;
            partner = entity;
        }
        return partner;
    }

    private boolean canBreedWith(Tapir partner) {
        return partner.isGrazing() && partner.m_146764_() == 0 && this.tapir.getFloraItem() == partner.getFloraItem();
    }

    private void moveTo(BlockPos pos) {
        this.tapir.m_21573_().m_26536_(this.tapir.m_21573_().m_26524_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0), 1.1);
    }
}

