/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.brain.yak;

import com.google.common.collect.ImmutableMap;
import com.teamabnormals.environmental.common.entity.animal.yak.Yak;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.Vec3;

public class YakRamBehavior
extends Behavior<Yak> {
    public static final int TIME_OUT_DURATION = 200;
    public static final float RAM_SPEED_FORCE_FACTOR = 1.65f;
    private final Function<Yak, UniformInt> getTimeBetweenRams;
    private final float speed;
    private final ToDoubleFunction<Yak> getKnockbackForce;
    private final Function<Yak, SoundEvent> getImpactSound;
    private Vec3 ramDirection;

    public YakRamBehavior(Function<Yak, UniformInt> ramCooldown, float speed, ToDoubleFunction<Yak> knockbackForce, Function<Yak, SoundEvent> impactSound) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_148202_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_148203_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 200);
        this.getTimeBetweenRams = ramCooldown;
        this.speed = speed;
        this.getKnockbackForce = knockbackForce;
        this.getImpactSound = impactSound;
        this.ramDirection = Vec3.f_82478_;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Yak yak) {
        return yak.m_6274_().m_21874_(MemoryModuleType.f_148203_);
    }

    protected boolean canStillUse(ServerLevel level, Yak yak, long gameTime) {
        return yak.m_6274_().m_21874_(MemoryModuleType.f_148203_);
    }

    protected void start(ServerLevel level, Yak yak, long gameTime) {
        BlockPos pos = yak.m_20183_();
        Brain<Yak> brain = yak.m_6274_();
        Vec3 ramTargetPos = (Vec3)brain.m_21952_(MemoryModuleType.f_148203_).get();
        this.ramDirection = new Vec3((double)pos.m_123341_() - ramTargetPos.m_7096_(), 0.0, (double)pos.m_123343_() - ramTargetPos.m_7094_()).m_82541_();
        brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(ramTargetPos.m_82549_(this.ramDirection.m_82490_(-4.0)), this.speed, 0));
    }

    protected void tick(ServerLevel level, Yak yak, long gameTime) {
        Brain<Yak> brain = yak.m_6274_();
        LivingEntity attackTarget = brain.m_21952_(MemoryModuleType.f_26372_).orElse(null);
        List list = level.m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26888_(entity -> Objects.equals(entity, attackTarget)), (LivingEntity)yak, yak.m_20191_());
        if (list.isEmpty()) {
            Optional destination = brain.m_21952_(MemoryModuleType.f_26370_);
            Optional ramTarget = brain.m_21952_(MemoryModuleType.f_148203_);
            if (destination.isEmpty() || ramTarget.isEmpty() || ((WalkTarget)destination.get()).m_26420_().m_7024_().m_82509_((Position)ramTarget.get(), 0.25)) {
                this.finishRam(level, yak);
            }
            return;
        }
        LivingEntity target = (LivingEntity)list.get(0);
        target.m_6469_(level.m_269111_().m_269333_((LivingEntity)yak), (float)yak.m_21133_(Attributes.f_22281_));
        int speedFactor = yak.m_21023_(MobEffects.f_19596_) ? yak.m_21124_(MobEffects.f_19596_).m_19564_() + 1 : 0;
        int slownessFactor = yak.m_21023_(MobEffects.f_19597_) ? yak.m_21124_(MobEffects.f_19597_).m_19564_() + 1 : 0;
        float effectSpeed = 0.25f * (float)(speedFactor - slownessFactor);
        float speedForce = Mth.m_14036_((float)(yak.m_6113_() * 1.65f), (float)0.2f, (float)3.0f) + effectSpeed;
        float knockbackForce = target.m_21275_(level.m_269111_().m_269333_((LivingEntity)yak)) ? 0.5f : 1.0f;
        target.m_147240_((double)(knockbackForce * speedForce) * this.getKnockbackForce.applyAsDouble(yak), this.ramDirection.m_7096_(), this.ramDirection.m_7094_());
        this.finishRam(level, yak);
        level.m_6269_(null, (Entity)yak, this.getImpactSound.apply(yak), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    protected void finishRam(ServerLevel level, Yak yak) {
        level.m_7605_((Entity)yak, (byte)59);
        yak.m_6274_().m_21879_(MemoryModuleType.f_148202_, (Object)this.getTimeBetweenRams.apply(yak).m_214085_(level.m_213780_()));
        yak.m_6274_().m_21936_(MemoryModuleType.f_148203_);
    }
}

