/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.brain.yak;

import com.google.common.collect.ImmutableMap;
import com.teamabnormals.environmental.common.entity.animal.yak.Yak;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class YakPrepareRamBehavior
extends Behavior<Yak> {
    public static final int TIME_OUT_DURATION = 160;
    private final ToIntFunction<Yak> getCooldownOnFail;
    private final int ramPrepareTime;
    private final Function<Yak, SoundEvent> getPrepareRamSound;
    private Optional<Long> ramTime = Optional.empty();
    private Optional<LivingEntity> ramCandidate = Optional.empty();

    public YakPrepareRamBehavior(ToIntFunction<Yak> getCooldownOnFail, int ramPrepareTime, Function<Yak, SoundEvent> getPrepareRamSound) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_148202_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_148203_, (Object)MemoryStatus.VALUE_ABSENT), 160);
        this.getCooldownOnFail = getCooldownOnFail;
        this.ramPrepareTime = ramPrepareTime;
        this.getPrepareRamSound = getPrepareRamSound;
    }

    protected void start(ServerLevel level, Yak yak, long gameTime) {
        yak.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(this::nominateTargetForRamming);
    }

    protected void stop(ServerLevel level, Yak yak, long gameTime) {
        Brain<Yak> brain = yak.m_6274_();
        if (!brain.m_21874_(MemoryModuleType.f_148203_)) {
            level.m_7605_((Entity)yak, (byte)59);
            brain.m_21879_(MemoryModuleType.f_148202_, (Object)this.getCooldownOnFail.applyAsInt(yak));
        }
    }

    protected boolean canStillUse(ServerLevel level, Yak yak, long gameTime) {
        return this.ramCandidate.isPresent() && this.ramCandidate.get().m_6084_() && yak.m_6274_().m_21874_(MemoryModuleType.f_26372_);
    }

    protected void tick(ServerLevel level, Yak yak, long gameTime) {
        if (this.ramCandidate.isEmpty()) {
            return;
        }
        yak.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        yak.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)this.ramCandidate.get(), true));
        level.m_7605_((Entity)yak, (byte)58);
        if (this.ramTime.isEmpty()) {
            this.ramTime = Optional.of(gameTime);
        }
        if (gameTime - this.ramTime.get() >= (long)this.ramPrepareTime) {
            yak.m_6274_().m_21879_(MemoryModuleType.f_148203_, (Object)this.ramCandidate.get().m_20182_());
            level.m_6269_(null, (Entity)yak, this.getPrepareRamSound.apply(yak), SoundSource.NEUTRAL, 1.0f, yak.m_6100_());
            this.ramCandidate = Optional.empty();
        }
    }

    private void nominateTargetForRamming(LivingEntity target) {
        this.ramTime = Optional.empty();
        this.ramCandidate = Optional.of(target);
    }
}

