/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.brain.yak;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.teamabnormals.environmental.common.entity.animal.yak.Yak;
import com.teamabnormals.environmental.core.registry.EnvironmentalMemoryModuleTypes;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraftforge.event.ForgeEventFactory;

public class YakGrazeBehavior
extends Behavior<Yak> {
    private static final int GRAZING_TIME = 40;
    private static final Predicate<BlockState> IS_TALL_GRASS = BlockStatePredicate.m_61287_((Block)Blocks.f_50034_);

    public YakGrazeBehavior() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26377_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT), 40);
    }

    public static BehaviorControl<Yak> createGrazeController() {
        return BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_257495_((MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get())).apply((Applicative)instance, grazingTicksMemory -> (level, yak, gameTime) -> {
            int grazingTicks = (Integer)instance.m_258051_(grazingTicksMemory);
            if (grazingTicks <= 0) {
                grazingTicksMemory.m_257971_();
                yak.m_6274_().m_21962_();
                level.m_7605_((Entity)yak, (byte)11);
            } else {
                grazingTicksMemory.m_257512_((Object)(grazingTicks - 1));
            }
            return true;
        }));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Yak yak) {
        if (yak.m_217043_().m_188503_(yak.m_6162_() ? 50 : 1000) != 0) {
            return false;
        }
        Brain<Yak> brain = yak.m_6274_();
        brain.m_21879_((MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get(), (Object)40);
        return level.m_8055_(yak.m_20183_().m_7495_()).m_60713_(Blocks.f_50440_) || IS_TALL_GRASS.test(level.m_8055_(yak.m_20183_()));
    }

    protected boolean canStillUse(ServerLevel level, Yak yak, long gameTime) {
        return (level.m_8055_(yak.m_20183_().m_7495_()).m_60713_(Blocks.f_50440_) || IS_TALL_GRASS.test(level.m_8055_(yak.m_20183_()))) && yak.m_6274_().m_21874_((MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get());
    }

    protected void start(ServerLevel level, Yak yak, long gameTime) {
        this.dementia(yak);
        level.m_7605_((Entity)yak, (byte)10);
    }

    protected void stop(ServerLevel level, Yak yak, long gameTime) {
        yak.m_6274_().m_21936_((MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get());
    }

    protected void tick(ServerLevel level, Yak yak, long gameTime) {
        this.dementia(yak);
        if (!yak.m_6274_().m_21938_((MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get(), (Object)Mth.m_184652_((int)4, (int)2))) {
            return;
        }
        BlockPos pos = yak.m_20183_();
        if (IS_TALL_GRASS.test(level.m_8055_(pos))) {
            if (ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)yak)) {
                level.m_46961_(pos, false);
            }
            yak.m_8035_();
            this.m_22562_(level, (LivingEntity)yak, gameTime);
            return;
        }
        if (level.m_8055_(pos = pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            if (ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)yak)) {
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)Blocks.f_50440_.m_49966_()));
                level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
            }
            yak.m_8035_();
            this.m_22562_(level, (LivingEntity)yak, gameTime);
        }
    }

    private void dementia(Yak yak) {
        yak.m_6274_().m_21936_(MemoryModuleType.f_26377_);
        yak.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        yak.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        yak.m_21573_().m_26573_();
    }
}

