/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.environmental.common.entity.animal.MuddyPig;
import com.teamabnormals.environmental.core.Environmental;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Pig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MuddyPigMudLayer<E extends Pig, M extends EntityModel<E>>
extends RenderLayer<E, M> {
    private static final ResourceLocation MUDDY_PIG_LOCATION = Environmental.location("textures/entity/pig/muddy_pig.png");
    private static final ResourceLocation DRIED_MUDDY_PIG_LOCATION = Environmental.location("textures/entity/pig/dried_muddy_pig.png");

    public MuddyPigMudLayer(RenderLayerParent<E, M> entityRenderer) {
        super(entityRenderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLightIn, E pig, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (MuddyPig.enabled() && MuddyPig.isMuddy(pig)) {
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)(MuddyPig.isDry(pig) ? DRIED_MUDDY_PIG_LOCATION : MUDDY_PIG_LOCATION)));
            this.m_117386_().m_6973_(pig, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.m_117386_().m_7695_(poseStack, builder, packedLightIn, LivingEntityRenderer.m_115338_(pig, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

