/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.environmental.common.entity.animal.deer.AbstractDeer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DeerModel<E extends AbstractDeer>
extends AgeableListModel<E> {
    private boolean hasAntlers;
    private float neckAngle;
    private float sprintAmount;
    private float hopAmount;
    private float hopAngle;
    public final ModelPart body;
    public final ModelPart neck;
    public final ModelPart head;
    public final ModelPart rightAntler;
    public final ModelPart leftAntler;
    public final ModelPart rightFrontLeg;
    public final ModelPart leftFrontLeg;
    public final ModelPart rightHindLeg;
    public final ModelPart leftHindLeg;
    public final ModelPart rightFrontBabyLeg;
    public final ModelPart leftFrontBabyLeg;
    public final ModelPart rightHindBabyLeg;
    public final ModelPart leftHindBabyLeg;

    public DeerModel(ModelPart root) {
        super(true, 14.5f, 2.0f);
        this.body = root.m_171324_("body");
        this.neck = root.m_171324_("neck");
        this.head = root.m_171324_("head");
        this.rightAntler = this.head.m_171324_("right_antler");
        this.leftAntler = this.head.m_171324_("left_antler");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
        this.rightHindLeg = root.m_171324_("right_hind_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
        this.rightFrontBabyLeg = root.m_171324_("right_front_baby_leg");
        this.leftFrontBabyLeg = root.m_171324_("left_front_baby_leg");
        this.rightHindBabyLeg = root.m_171324_("right_hind_baby_leg");
        this.leftHindBabyLeg = root.m_171324_("left_hind_baby_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -8.0f, -9.0f, 8.0f, 8.0f, 17.0f), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f));
        body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171481_(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)8.0f));
        root.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.5f, -10.0f, -2.0f, 5.0f, 10.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)-7.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(33, 0).m_171488_(-2.5f, -5.0f, -4.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.05f)).m_171514_(32, 25).m_171506_(-1.5f, -3.0f, -8.0f, 3.0f, 3.0f, 4.0f, false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-5.75f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(33, 0).m_171480_().m_171481_(-1.0f, -4.0f, 0.5f, 1.0f, 4.0f, 2.0f), PartPose.m_171423_((float)-2.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(33, 0).m_171481_(0.0f, -4.0f, 0.5f, 1.0f, 4.0f, 2.0f), PartPose.m_171423_((float)2.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        head.m_171599_("right_antler", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171480_().m_171481_(-0.5f, -10.0f, 0.0f, 0.0f, 11.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.25f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        head.m_171599_("left_antler", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171481_(0.5f, -10.0f, 0.0f, 0.0f, 11.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.25f, (float)0.0f, (float)0.7854f, (float)0.0f));
        root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(20, 25).m_171480_().m_171481_(-0.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f), PartPose.m_171419_((float)-3.5f, (float)14.0f, (float)-5.0f));
        root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(20, 25).m_171481_(-2.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f), PartPose.m_171419_((float)3.5f, (float)14.0f, (float)-5.0f));
        root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(20, 25).m_171480_().m_171481_(-0.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f), PartPose.m_171419_((float)-3.5f, (float)14.0f, (float)6.0f));
        root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(20, 25).m_171481_(-2.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f), PartPose.m_171419_((float)3.5f, (float)14.0f, (float)6.0f));
        CubeDeformation cubedeformation = new CubeDeformation(0.0f, 3.0f, 0.0f);
        root.m_171599_("right_front_baby_leg", CubeListBuilder.m_171558_().m_171514_(20, 25).m_171480_().m_171488_(-0.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.m_171419_((float)-3.5f, (float)14.0f, (float)-5.0f));
        root.m_171599_("left_front_baby_leg", CubeListBuilder.m_171558_().m_171514_(20, 25).m_171488_(-2.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.m_171419_((float)3.5f, (float)14.0f, (float)-5.0f));
        root.m_171599_("right_hind_baby_leg", CubeListBuilder.m_171558_().m_171514_(20, 25).m_171480_().m_171488_(-0.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.m_171419_((float)-3.5f, (float)14.0f, (float)6.0f));
        root.m_171599_("left_hind_baby_leg", CubeListBuilder.m_171558_().m_171514_(20, 25).m_171488_(-2.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.m_171419_((float)3.5f, (float)14.0f, (float)6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(E entity, float limbSwing, float limbSwingAmount, float partialTick) {
        boolean flag1;
        this.hasAntlers = ((AbstractDeer)((Object)entity)).hasAntlers();
        this.neckAngle = ((AbstractDeer)((Object)entity)).getNeckAngle(partialTick);
        this.hopAngle = ((AbstractDeer)((Object)entity)).getHopAngle(partialTick);
        this.hopAmount = ((AbstractDeer)((Object)entity)).getHopAmount(partialTick);
        this.sprintAmount = ((AbstractDeer)((Object)entity)).getSprintAmount(partialTick) * (1.0f - this.hopAmount);
        boolean flag = this.f_102610_;
        this.rightAntler.f_104207_ = flag1 = this.hasAntlers && !flag;
        this.leftAntler.f_104207_ = flag1;
        this.rightFrontLeg.f_104207_ = !flag;
        this.leftFrontLeg.f_104207_ = !flag;
        this.rightHindLeg.f_104207_ = !flag;
        this.leftHindLeg.f_104207_ = !flag;
        this.rightFrontBabyLeg.f_104207_ = flag;
        this.leftFrontBabyLeg.f_104207_ = flag;
        this.rightHindBabyLeg.f_104207_ = flag;
        this.leftHindBabyLeg.f_104207_ = flag;
        this.body.f_104201_ = flag ? 8.0f : 14.0f;
        this.neck.f_104201_ = flag ? 4.0f : 10.0f;
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float neckanglerad = this.neckAngle * ((float)Math.PI / 180);
        float eatamount = Mth.m_14036_((float)((this.neckAngle - 90.0f) / 40.0f), (float)0.0f, (float)1.0f);
        float noeatamount = 1.0f - eatamount;
        float noanimamount = Math.min(1.0f - this.sprintAmount, 1.0f - this.hopAmount);
        this.neck.f_104203_ = neckanglerad;
        this.body.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.25f * limbSwingAmount * this.sprintAmount;
        if (this.hopAngle != 0.0f) {
            this.body.f_104203_ += this.hopAngle;
        }
        this.neck.f_104201_ += (float)Math.tan(this.body.f_104203_) * 7.0f;
        this.neck.f_104202_ = -7.0f - (float)Math.tan(this.body.f_104203_) * 4.0f;
        this.head.f_104201_ = 2.0f - (this.f_102610_ ? 0.7f : 1.0f) * 11.0f * Mth.m_14089_((float)neckanglerad) + this.neck.f_104201_;
        this.head.f_104202_ = 1.5f - (this.f_102610_ ? 0.6f : 1.0f) * 12.0f * Mth.m_14031_((float)neckanglerad) + this.neck.f_104202_;
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180) * noeatamount;
        this.head.f_104203_ += (Mth.m_14031_((float)(ageInTicks * 0.7f)) * 0.15f + 0.65f) * eatamount;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180) * noeatamount;
        this.leftFrontLeg.f_104201_ = this.rightFrontLeg.f_104201_ = 14.0f + (float)Math.tan(this.body.f_104203_) * 5.0f;
        this.leftHindLeg.f_104201_ = this.rightHindLeg.f_104201_ = 14.0f - (float)Math.tan(this.body.f_104203_) * 6.0f;
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.2f * limbSwingAmount * noanimamount;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount * noanimamount;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount * noanimamount;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.2f * limbSwingAmount * noanimamount;
        if (this.sprintAmount > 0.0f) {
            this.rightFrontLeg.f_104203_ += (-0.5235988f + Mth.m_14089_((float)(ageInTicks * 0.6662f + (float)Math.PI))) * limbSwingAmount * this.sprintAmount;
            this.leftFrontLeg.f_104203_ += (-0.5235988f + Mth.m_14089_((float)(ageInTicks * 0.6662f + (float)Math.PI + 0.6f))) * limbSwingAmount * this.sprintAmount;
            this.rightHindLeg.f_104203_ += (0.5235988f + Mth.m_14089_((float)(ageInTicks * 0.6662f + 0.6f))) * limbSwingAmount * this.sprintAmount;
            this.leftHindLeg.f_104203_ += (0.5235988f + Mth.m_14089_((float)(ageInTicks * 0.6662f))) * limbSwingAmount * this.sprintAmount;
        }
        if (this.hopAngle != 0.0f) {
            this.rightFrontLeg.f_104203_ += -this.hopAngle * 3.0f;
            this.leftFrontLeg.f_104203_ += -this.hopAngle * 3.0f * 0.85f;
            this.rightHindLeg.f_104203_ += -this.hopAngle * 2.5f * 0.85f;
            this.leftHindLeg.f_104203_ += -this.hopAngle * 2.5f;
        }
        if (this.f_102610_) {
            this.rightFrontBabyLeg.m_104315_(this.rightFrontLeg);
            this.leftFrontBabyLeg.m_104315_(this.leftFrontLeg);
            this.rightHindBabyLeg.m_104315_(this.rightHindLeg);
            this.leftHindBabyLeg.m_104315_(this.leftHindLeg);
            this.rightFrontBabyLeg.f_104201_ -= 3.0f;
            this.leftFrontBabyLeg.f_104201_ -= 3.0f;
            this.rightHindBabyLeg.f_104201_ -= 3.0f;
            this.leftHindBabyLeg.f_104201_ -= 3.0f;
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.neck, (Object)this.body, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.leftHindLeg, (Object)this.rightHindLeg, (Object)this.leftFrontBabyLeg, (Object)this.rightFrontBabyLeg, (Object)this.leftHindBabyLeg, (Object)this.rightHindBabyLeg);
    }
}

