/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.uncandango.alltheleaks.AllTheLeaks;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fml.loading.FMLPaths;

public class ATLProperties {
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
    private static final Path path = FMLPaths.CONFIGDIR.get().resolve("alltheleaks.json");
    private static JsonObject properties;
    private static final JsonObject defaultProperties;
    private static ATLProperties INSTANCE;
    public boolean preventSearchIgnoredItems;
    public boolean ingredientDedupe;
    public boolean resourceLocationDedupe;
    public boolean debugItemStackModifications;
    public int logIntervalInMinutes;
    public boolean showSummaryOnDebugScreen;
    public int memoryUsageWarningPercentage;

    private ATLProperties() {
        this.load();
    }

    public static ATLProperties get() {
        if (INSTANCE == null) {
            INSTANCE = new ATLProperties();
        }
        return INSTANCE;
    }

    private static JsonObject getDefaultProperties() {
        JsonObject properties = new JsonObject();
        properties.addProperty("preventSearchIgnoredItems", Boolean.valueOf(false));
        properties.addProperty("ingredientDedupe", Boolean.valueOf(false));
        properties.addProperty("resourceLocationDedupe", Boolean.valueOf(false));
        properties.addProperty("debugItemStackModifications", Boolean.valueOf(false));
        properties.addProperty("logIntervalInMinutes", (Number)10);
        properties.addProperty("showSummaryOnDebugScreen", Boolean.valueOf(true));
        properties.addProperty("memoryUsageWarningPercentage", (Number)90);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (!path.toFile().exists()) {
            ATLProperties.save();
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            properties = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            this.preventSearchIgnoredItems = GsonHelper.m_13855_((JsonObject)properties, (String)"preventSearchIgnoredItems", (boolean)false);
            this.ingredientDedupe = GsonHelper.m_13855_((JsonObject)properties, (String)"ingredientDedupe", (boolean)false);
            this.debugItemStackModifications = GsonHelper.m_13855_((JsonObject)properties, (String)"debugItemStackModifications", (boolean)false);
            this.resourceLocationDedupe = GsonHelper.m_13855_((JsonObject)properties, (String)"resourceLocationDedupe", (boolean)false);
            this.logIntervalInMinutes = GsonHelper.m_13824_((JsonObject)properties, (String)"logIntervalInMinutes", (int)10);
            this.showSummaryOnDebugScreen = GsonHelper.m_13855_((JsonObject)properties, (String)"showSummaryOnDebugScreen", (boolean)true);
            this.memoryUsageWarningPercentage = GsonHelper.m_13824_((JsonObject)properties, (String)"memoryUsageWarningPercentage", (int)90);
        }
        catch (IOException e) {
            AllTheLeaks.LOGGER.error("Failed to load config file", (Throwable)e);
        }
        finally {
            ATLProperties.save();
        }
    }

    public static void save() {
        if (properties == null) {
            properties = defaultProperties.deepCopy();
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            defaultProperties.asMap().forEach((key, val) -> properties.asMap().putIfAbsent(key, val));
            GSON.toJson((JsonElement)properties, (Appendable)writer);
        }
        catch (IOException e) {
            AllTheLeaks.LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }

    static {
        defaultProperties = ATLProperties.getDefaultProperties();
    }
}

